// ===========================================================================
//	LGAPictureMixin.h			PowerPlant 2.2.1	1995-1999 Metrowerks Inc.
// ===========================================================================
//	Original Author: Robin Mair

#ifdef PowerPlant_PCH
	#include PowerPlant_PCH
#endif
#include "PP_Prefix.h"
#include "UException.h"

#include "LGAPictureMixin.h"

PP_Begin_Namespace_PowerPlant


// ---------------------------------------------------------------------------
//	 LGAPictureMixin						Default Constructor		  [public]
// ---------------------------------------------------------------------------

LGAPictureMixin::LGAPictureMixin()
{
	mPictureH			= nil;
	mPictureResID		= 0;
	mDisposePictureH	= false;
}


// ---------------------------------------------------------------------------
// 	 LGAPictureMixin						Copy Constructor		  [public]
// ---------------------------------------------------------------------------

LGAPictureMixin::LGAPictureMixin(
	const LGAPictureMixin&	inOriginal)
{
	mPictureH			= inOriginal.mPictureH;
	mPictureResID		= inOriginal.mPictureResID;
	mDisposePictureH	= inOriginal.mDisposePictureH;
}


// ---------------------------------------------------------------------------
// 	 ~LGAPictureMixin						Destructor				  [public]
// ---------------------------------------------------------------------------

LGAPictureMixin::~LGAPictureMixin()
{
	DisposePictureHandle();
}

#pragma mark -


// ---------------------------------------------------------------------------
//	 GetPictureHandle												  [public]
// ---------------------------------------------------------------------------


PicHandle
LGAPictureMixin::GetPictureHandle() const
{
	PicHandle	pictH = mPictureH;

	if ( (pictH == nil) &&
		 (mPictureResID != 0) &&
		 (mPictureResID != resID_Undefined) ) {

		pictH = ::GetPicture(mPictureResID);
	}

	return pictH;
}


// ---------------------------------------------------------------------------
//	 GetPictureSize												  [public]
// ---------------------------------------------------------------------------

SDimension16
LGAPictureMixin::GetPictureSize() const
{
	SDimension16	pictureSize = { 0, 0 };

	PicHandle	pictH = GetPictureHandle();

	if (pictH != nil) {

		Rect	pictFrame = (**pictH).picFrame;

		pictureSize.width  = (SInt16) (pictFrame.right - pictFrame.left);
		pictureSize.height = (SInt16) (pictFrame.bottom - pictFrame.top);
	}

	return pictureSize;
}


// ---------------------------------------------------------------------------
//	 GetPictureFrame												  [public]
// ---------------------------------------------------------------------------

void
LGAPictureMixin::GetPictureFrame(
	Rect&	outFrame)
{
	outFrame = Rect_0000;				// If there is no Picture

	PicHandle	pictH = GetPictureHandle();

	if (pictH != nil) {
		outFrame = (**pictH).picFrame;
	}
}


// ---------------------------------------------------------------------------
//	 SetPictureHandle												  [public]
// ---------------------------------------------------------------------------

void
LGAPictureMixin::SetPictureHandle(
	PicHandle	inPictureH,
	bool		inDisposesHandle)
{
	if (mPictureH != inPictureH) {			// Setting to a different Picture
		DisposePictureHandle();				// Dispose current Picture
		mPictureH = inPictureH;
	}

	mDisposePictureH = inDisposesHandle;

	mPictureResID	 = 0;					// Don't use resource ID
}


// ---------------------------------------------------------------------------
//	 SetPictureResourceID											  [public]
// ---------------------------------------------------------------------------

void
LGAPictureMixin::SetPictureResourceID(
	ResIDT	inResID)
{
	DisposePictureHandle();				// Dispose current Picture Handle

	mPictureResID = inResID;
}


// ---------------------------------------------------------------------------
//	 CalcLocalPictureRect											  [public]
// ---------------------------------------------------------------------------

void
LGAPictureMixin::CalcLocalPictureRect(
	Rect&	/* outRect */)
{
}

#pragma mark -

// ---------------------------------------------------------------------------
//	 DisposePictureHandle											  [public]
// ---------------------------------------------------------------------------

void
LGAPictureMixin::DisposePictureHandle()
{
										// Dispose Picture if we own it and
										//   it exists
	if (DisposesPictureH() && (mPictureH != nil)) {
		::DisposeHandle((Handle) mPictureH);
	}

	mPictureH = nil;
}


// ---------------------------------------------------------------------------
//	 CalcPictureLocation										   [protected]
// ---------------------------------------------------------------------------

void
LGAPictureMixin::CalcPictureLocation(
	Point&	/* outPictureLocation */)
{
}


PP_End_Namespace_PowerPlant
